/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.mana;

import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="ars_nouveau", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ManaAttributes {
    public static final HashMap<RegistryObject<Attribute>, UUID> UUIDS = new HashMap();
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"ars_nouveau");
    public static final RegistryObject<Attribute> MANA_REGEN = ManaAttributes.registerAttribute("mana_regen", id -> new RangedAttribute(id, 0.0, 0.0, 2000.0).m_22084_(true));
    public static final RegistryObject<Attribute> MAX_MANA = ManaAttributes.registerAttribute("max_mana", id -> new RangedAttribute(id, 0.0, 0.0, 10000.0).m_22084_(true));

    public static RegistryObject<Attribute> registerAttribute(String name, Function<String, Attribute> attribute) {
        RegistryObject registryObject = ATTRIBUTES.register(name, () -> (Attribute)attribute.apply("attribute.name.ars_nouveau." + name));
        UUIDS.put((RegistryObject<Attribute>)registryObject, UUID.randomUUID());
        return registryObject;
    }

    @SubscribeEvent
    public static void modifyEntityAttributes(EntityAttributeModificationEvent event) {
        event.getTypes().stream().filter(e -> e == EntityType.f_20532_).forEach(e -> {
            event.add(e, (Attribute)MAX_MANA.get());
            event.add(e, (Attribute)MANA_REGEN.get());
        });
    }
}

